;Sample Add-in for TV's server
;How to install this add-in:
;-Add a value on registerkey HKEY_LOCAL_MACHINE\SOFTWARE\TV's software\TV's server\add-in
; The valuename may be random, the value should be the url to this DLL
;-Restart TV's server
;Go to localhost:81, click on Add-in and you will see this add-in in the list
;For more information go to http://www.tvsoftware.nl/server.php?page=addin
format PE GUI 4.0 DLL
entry DllStart

;---------

section '.text' executable code

;---------

include 'WIN32A.INC'

;---------

DllStart:
mov eax,1
ret 0xC

;---------

AddinData:
;0x8 = The number of the data that the server is requesting
;0xC = Reserved
push ebp
mov ebp,esp

cmp dword [ebp+0x8],0x4 ;Add-in protocol version
je SendVersiona

cmp dword [ebp+0x8],0x8 ;Add-in type
je SendType

cmp dword [ebp+0x8],0xC ;Add-in miliseconds time-out
je SendTimeout

cmp dword [ebp+0x8],0x10 ;Add-in handle-proc
je SendProc

cmp dword [ebp+0x8],0x14 ;Add-in friendly name
je SendName

cmp dword [ebp+0x8],0x18 ;Add-in description
je SendDescription

cmp dword [ebp+0x8],0x1C ;Add-in version
je SendVersionb

cmp dword [ebp+0x8],0x20 ;Add-in Creator
je SendCreator

cmp dword [ebp+0x8],0x24 ;Add-in Status message
je SendStatus

cmp dword [ebp+0x8],0x28 ;Add-in Status message priority
je SendPriority

cmp dword [ebp+0x8],0x2C ;Add-in has config
je SendHasConfig

cmp dword [ebp+0x8],0x30 ;Add-in ConfigString
je SendSendConfigString

cmp dword [ebp+0x8],0x34 ;Add-in SetConfigProc
je SendSetConfigProc

jmp NoSettings

;------

SendVersiona:
mov eax,0x00000001 ;Version 1
jmp ExitAddinData

SendType:
mov eax,0x8 ;Type 2
jmp ExitAddinData

SendTimeout:
mov eax,1000 ;Send the timeout that this add-in need
jmp ExitAddinData

SendProc:
mov eax,HandleFunction	;Proc of the handle function
jmp ExitAddinData

SendName: ;Send Add-in name
mov eax,FriendlyName
jmp ExitAddinData

SendDescription:
mov eax,description
jmp ExitAddinData

SendVersionb:
mov eax,version
jmp ExitAddinData

SendCreator:
mov eax,creator
jmp ExitAddinData

SendStatus:
mov eax,[Status]
jmp ExitAddinData

SendPriority:
mov eax,3
jmp ExitAddinData

SendHasConfig:
mov eax,1
jmp ExitAddinData

SendSendConfigString:
mov eax,Config
jmp ExitAddinData

SendSetConfigProc:
mov eax,ConfigProc
jmp ExitAddinData

;------

ExitAddinData:
mov esp,ebp
pop ebp
ret 0x8

NoSettings:
mov eax,0
jmp ExitAddinData

;---------

ConfigProc:
;0x8 = Name
;0xC = Value
push ebp
mov ebp,esp

;The only name that wil lbe send is test with the new value (see string Config only input test has been configurated)

mov esp,ebp
pop ebp
ret 0x8

;---------


HandleFunction:
;0x8 Pointer to Information_table
push ebp
mov ebp,esp

mov ecx,dword [ebp+0x8]
mov ecx,dword [ecx] ;This is the pointer to the SERVER_NAME

mov ecx,dword [ebp+0x8]
mov ecx,dword [ecx+0x4] ;This is the pointer to the SERVER_VERSION




EndFunction:
mov eax,1
mov esp,ebp
pop ebp
ret 0x4

;---------

section '.edata' export data readable

export 'dll.DLL',\
	 AddinData,'AddinData'

;---------

section '.data' data readable writeable
;It is able to use *, on every request the function will be called (this was made to
;The string down here means on every request that starts with PUT or DELETE the function will be called
;(this MUST end with 2 zero bytes)
FriendlyName db 'Test Add-in2',0
description db 'Testing add-in system2',0
version db '1.01',0
creator db "TV's software",0
Stata db 'No update',0
Status dd Stata
Config db '<TR><TD  vAlign="baseline">MyConfigTest</TD>',\
'<TD style="WIDTH: 3px" vAlign="baseline">:</TD>',\
'<TD><INPUT id="test" style="WIDTH: 416px" type="text" size="64" name="test" value=""><br><FONT size=2>(example c:/mywebs/)</font></TD>',\
'</TR>',0



;---------

section '.reloc' fixups data discardable